INCLUDE ht66f2370.inc
INCLUDE "BC2502_I2C_Set.inc"
INCLUDE "ui.inc"

;------------------------------------------------------------------        
;set RF carrier frequency
;------------------------------------------------------------------        
FREQ		EQU	RF_FREQ		;*10Hz. It can be changed according to application.
				
XTAL		EQU	1600		;*10KHz
FIF			EQU	20000		;*10Hz

BW187K		EQU	0
BW93K		EQU	1


FSK_FILTER	EQU	BW93K
XO_TRIM		EQU	10h
;------------------------------------------------------------------        
DEVICE_NO	EQU	25h

;----5V--------  
BC_CFG1		EQU	00h
BC_FSKDM1	EQU	05h
BC_FSKDM2	EQU	06h
BC_OOKDM1	EQU	08h
BC_OOKDM2	EQU	09h
BC_LOG1		EQU	0Ah
BC_AGC1		EQU	0Bh
BC_AGC2		EQU	0Ch
BC_AGC5		EQU	0Fh
BC_OM		EQU	10h
BC_RXG1		EQU	11h
BC_SX1		EQU	12h
BC_SX2		EQU	13h
BC_SX3		EQU	14h
BC_SX4		EQU	15h
BC_RX1		EQU	17h
BC_CA1		EQU	1Bh
BC_XO1		EQU	1Fh
BC_TEST3	EQU	32h
;----1.2V--------
BC_I2C1		EQU	40h
BC_CA3		EQU	46h
BC_CHIP1	EQU	60h
BC_CHIP2	EQU	61h
BC_CHIP3	EQU	62h
;------------------------------------------------------------------        
BC_CFG1_V	EQU			40h					;b6=AGC_EN, b5=Light sleep mode switch
BC_FSKDM1_V	EQU			(80h+FSK_FILTER)	;8xh=FSK



BC_FSKDM2_V	EQU			71h
BC_AGC1_V	EQU			42h
BC_AGC2_V	EQU			27h

BC_OOKDM1_V	EQU			18h

BC_AGC5_V	EQU			04h

BC_CA1_V	EQU			2Fh	
BC_TEST3_V	EQU			082h

;-----1.2V------
BC_CA3_V	EQU			00h
b_VCOCAL_EN	EQU			01h

#define 	FRDIV		0
#define 	BC_RXG1_V	69h
#define		BC_RX1_V	06Fh

if	(FREQ < 38000000)
	#define	RF_BAND		0
	#define	NFREQ		((FREQ-FIF)/1000)*(1<<FRDIV)*2
	#define	MMDEXT		1
endif	
if	(FREQ >= 38000000) and (FREQ < 47000000)
	#define	RF_BAND		1
	#define	NFREQ		((FREQ-FIF)/1000)*(1<<FRDIV)
	#define	MMDEXT		1
endif	
if	(FREQ >= 47000000) and (FREQ <= 51000000)
	#define	RF_BAND		2
	#define	NFREQ		((FREQ-FIF)/1000)*(1<<FRDIV)
	#define	MMDEXT		1
endif	
if(FREQ >= 80000000) and (FREQ <= 89000000)
	#define	RF_BAND		3	
	#define	NFREQ		((FREQ-FIF)/1000)*(1<<FRDIV)
	#define	MMDEXT		0
endif
if(FREQ > 89000000)
	#define	RF_BAND		3	
	#define	NFREQ		((FREQ-FIF)/1000)*(1<<FRDIV)
	#define	MMDEXT		0
endif


#define 	BC_XO1_V	((FRDIV<<6)+XO_TRIM)	;b[4:0]=XO_TRIM[4:0]
#define		BC_OOKDM2_V	7Fh
#define		BC_LOG1_V	7Fh

#define		D_N			((NFREQ*8)/(XTAL*10))
#define		D_K1		((NFREQ*8*16)-(D_N*XTAL*10*16))
#define		D_KH		(D_K1/(XTAL*10))
#define		D_KH1		((D_K1*256)-(D_KH*XTAL*10*256))
#define		D_KM		(D_KH1/(XTAL*10))
#define		D_KM1		((D_KH1*256)-(D_KM*XTAL*10*256))
#define		D_KL		(D_KM1/(XTAL*10))

BC_OM_V		EQU 		(RF_BAND << 5)
BC_SX1_V	EQU			((MMDEXT<<7) + D_N)		
BC_SX2_V	EQU			D_KL		
BC_SX3_V	EQU			D_KM		
BC_SX4_V	EQU			(60h +D_KH)

